package javasposh;

import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.exceptions.PogamutException;
import cz.cuni.pogamut.exceptions.ScriptedAgentException;
import cz.cuni.pogamut.introspection.PogProp;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;
import cz.cuni.utils.Config;
import java.io.File;
import java.util.ArrayList;

/**
 *  WARNING -> before running this project from IDE you need to alter the getPlanFile() method,
 *  setting correct directory instead of JavaSPOSH!
 *
 *  During the creation of the sample project you've entered the name of the project that becomes the
 *  directory inside pogamut platform / projects directory. That's the name you have to enter into
 *  the getPlanFile(). If you are unsure, please open menu Tools / Options / Pogamut. There you will
 *  find a path to the pogamut platform directory. There you will find the 'projects' directory where
 *  the JavaSPOSH sample resides. 
 *
 *  Or you may try to search for the file 'sposhPlan.lap' file, but that may give you more results if you have
 *  already created more projects that are using SPOSH engine.
 *
 *
 *  JavaSPOSH sample
 *  ----------------
 *
 *  This bot is a simplified Hunter (see sample 04 - Hunter), that is using reactive planner SPOSH as
 *  it's action selection mechanism.
 *
 *  The plan is described in file 'sposhPlan.lap' and the actions and sensors are in 'MyBehavior.java'.
 */
public class Main extends SPoshBot {
    
    /** Creates a new instance of agent. */
    public Main() throws ScriptedAgentException {
        super();        
    }

	/** Returns a new behavior for the SPOSH engine */
    protected JavaBehaviour getBehaviour() {
        return new MyBehaviour("MyBehaviour", this.log, this);
    }
    
    /** 
     * Returns path where the sposhPlan.lap file defining the plan for SPOSH resides.
     * 
     * !!! NOTE !!!
     * You have to alter this, JavaSPOSH directory is probably different according to what name you have entered
     * when asked for the name of the project!.
     */
    protected String getPlanFile() {
        return Config.getProjectsPath()+File.separator+"DanLessner-DM-SPOSH"+File.separator+"src"+File.separator+"javasposh"+File.separator+"sposhPlan.lap";
    }
    
    protected void prePrepareAgent()  throws PogamutException {        
        super.prePrepareAgent();        
    }
    
    protected void postPrepareAgent() throws PogamutException {        
        super.postPrepareAgent();
        this.getBody().initializer.setBotSkillLevel(3);        
    }
    
    private boolean first = true;
    
    protected void doLogic() {
        if (first) { // workaround :-(
            this.getBody().configureAutoTrace(false);
            first = false;
        }
        super.doLogic();
    }
    
    protected void shutdownAgent() throws PogamutException {        
        super.shutdownAgent();        
    }
    
    
/**
 * NOTE: this method MUST REMAIN DEFINED + MUST REMAIN EMPTY, due to technical reasons.
 */			        
    public static void main(String[] args) {
    }
}
